/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.ClickableDrawable;
import com.roguewave.chart.core.v2_1.graphics.ColorArray;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.AreaChartStack;
import java.util.Vector;

class StackedAreaRow
extends ChartPart {
    private static final double defaultDepth = 0.5;

    public StackedAreaRow(ChartProperties properties, DataModel data, Transform3D transform, ColorArray colors) {
        double depth = properties.getProperty("PartDepth", 0.5);
        int rows = data.getRowCount();
        int stacks = data.getColumnCount() - 1;
        double x = (double)(-stacks) / 2.0;
        Transform3D trans = new Transform3D(transform, Transform3D.translate(x, 0.0, 0.0));
        AreaChartStack stack = new AreaChartStack(properties, data, 0, trans, depth, colors);
        SortTreeNode stn = stack.getSortTree();
        Vector polyArrays = stack.get2DPolygons();
        for (int i = 0; i < polyArrays.size(); ++i) {
            this.add2DPolygons((Polygon3D[])polyArrays.elementAt(i));
        }
        Vector clickables = stack.get2DClickables();
        for (int i = 0; i < clickables.size(); ++i) {
            this.add2DClickable((ClickableDrawable)clickables.elementAt(i));
        }
        for (int column = 1; column < stacks; ++column) {
            trans = new Transform3D(transform, Transform3D.translate(x += 1.0, 0.0, 0.0));
            stack = new AreaChartStack(properties, data, column, trans, depth, colors);
            Point3D[] testPoints = new Point3D[]{trans.transform(new Point3D(0.0, 0.0, 0.0)), trans.transform(new Point3D(0.0, 0.0, 1.0)), trans.transform(new Point3D(0.0, 1.0, 0.0))};
            stn = new SortTreeInternal(stn, stack.getSortTree(), testPoints);
            polyArrays = stack.get2DPolygons();
            for (int i = 0; i < polyArrays.size(); ++i) {
                this.add2DPolygons((Polygon3D[])polyArrays.elementAt(i));
            }
            clickables = stack.get2DClickables();
            for (int i = 0; i < clickables.size(); ++i) {
                this.add2DClickable((ClickableDrawable)clickables.elementAt(i));
            }
        }
        this.setSortTree(stn);
    }
}

